<?php
/**
 * Continent helper.
 *
 * @package WP_Defender\Traits
 * @since      3.10.0
 */

namespace WP_Defender\Traits;

trait Continent {


	/**
	 * Copy the list from https://en.wikipedia.org/wiki/United_Nations_geoscheme.
	 * It's without specific places:
	 * -Asia/Pacific Region,
	 * -Antarctica,
	 * -Anonymous Proxy,
	 * -Satellite Provider,
	 * -Other Country,
	 * which are in the list of countries.
	 * Note: there must be strict compliance with Country trait.
	 *
	 * @return array
	 */
	protected function get_countries_with_continents(): array {
		return apply_filters(
			'wd_countries_with_continents',
			array(
				'AF' => array(
					'name' => esc_html__( 'Africa', 'wpdef' ),
					'area' => array(
						'AF1' => array(
							'name'      => esc_html__( 'Northern Africa', 'wpdef' ),
							'countries' => array(
								'DZ' => 'Algeria',
								'EG' => 'Egypt',
								'LY' => 'Libyan Arab Jamahiriya',
								'MA' => 'Morocco',
								'SD' => 'Sudan',
								'TN' => 'Tunisia',
								'EH' => 'Western Sahara',
							),
						),
						'AF2' => array(
							'name'      => esc_html__( 'Eastern Africa', 'wpdef' ),
							'countries' => array(
								'IO' => 'British Indian Ocean Territory',
								'BI' => 'Burundi',
								'KM' => 'Comoros',
								'DJ' => 'Djibouti',
								'ER' => 'Eritrea',
								'ET' => 'Ethiopia',
								'TF' => 'French Southern Territories',
								'KE' => 'Kenya',
								'MG' => 'Madagascar',
								'MW' => 'Malawi',
								'MU' => 'Mauritius',
								'YT' => 'Mayotte',
								'MZ' => 'Mozambique',
								'RE' => 'Reunion',
								'RW' => 'Rwanda',
								'SC' => 'Seychelles',
								'SO' => 'Somalia',
								'SS' => 'South Sudan',
								'UG' => 'Uganda',
								'TZ' => 'Tanzania, United Republic of',
								'ZM' => 'Zambia',
								'ZW' => 'Zimbabwe',
							),
						),
						'AF3' => array(
							'name'      => esc_html__( 'Western Africa', 'wpdef' ),
							'countries' => array(
								'BJ' => 'Benin',
								'BF' => 'Burkina Faso',
								'CV' => 'Cape Verde',
								'CI' => "Cote d'Ivoire",
								'GM' => 'Gambia',
								'GH' => 'Ghana',
								'GN' => 'Guinea',
								'GW' => 'Guinea-Bissau',
								'LR' => 'Liberia',
								'ML' => 'Mali',
								'MR' => 'Mauritania',
								'NE' => 'Niger',
								'NG' => 'Nigeria',
								'SH' => 'Saint Helena',
								'SN' => 'Senegal',
								'SL' => 'Sierra Leone',
								'TG' => 'Togo',
							),
						),
						'AF4' => array(
							'name'      => esc_html__( 'Central Africa', 'wpdef' ),
							'countries' => array(
								'AO' => 'Angola',
								'CM' => 'Cameroon',
								'CF' => 'Central African Republic',
								'TD' => 'Chad',
								'CG' => 'Congo',
								'CD' => 'Congo, The Democratic Republic of the',
								'GQ' => 'Equatorial Guinea',
								'GA' => 'Gabon',
								'ST' => 'Sao Tome and Principe',
							),
						),
						'AF5' => array(
							'name'      => esc_html__( 'Southern Africa', 'wpdef' ),
							'countries' => array(
								'BW' => 'Botswana',
								'SZ' => 'Swaziland',
								'LS' => 'Lesotho',
								'NA' => 'Namibia',
								'ZA' => 'South Africa',
							),
						),
					),
				),
				'AS' => array(
					'name' => esc_html__( 'Asia', 'wpdef' ),
					'area' => array(
						'AS1' => array(
							'name'      => esc_html__( 'Central Asia', 'wpdef' ),
							'countries' => array(
								'KZ' => 'Kazakhstan',
								'KG' => 'Kyrgyzstan',
								'TJ' => 'Tajikistan',
								'TM' => 'Turkmenistan',
								'UZ' => 'Uzbekistan',
							),
						),
						'AS2' => array(
							'name'      => esc_html__( 'Eastern Asia', 'wpdef' ),
							'countries' => array(
								'CN' => 'China',
								'HK' => 'Hong Kong',
								'MO' => 'Macao',
								'JP' => 'Japan',
								'MN' => 'Mongolia',
								'KP' => "Korea, Democratic People's Republic of",
								'KR' => 'Korea, Republic of',
								'TW' => 'Taiwan',
							),
						),
						'AS3' => array(
							'name'      => esc_html__( 'South Asia', 'wpdef' ),
							'countries' => array(
								'AF' => 'Afghanistan',
								'BD' => 'Bangladesh',
								'BT' => 'Bhutan',
								'IN' => 'India',
								'MV' => 'Maldives',
								'NP' => 'Nepal',
								'PK' => 'Pakistan',
								'LK' => 'Sri Lanka',
							),
						),
						'AS4' => array(
							'name'      => esc_html__( 'South-Eastern Asia', 'wpdef' ),
							'countries' => array(
								'BN' => 'Brunei Darussalam',
								'KH' => 'Cambodia',
								'ID' => 'Indonesia',
								'LA' => "Lao People's Democratic Republic",
								'MY' => 'Malaysia',
								'MM' => 'Myanmar',
								'PH' => 'Philippines',
								'SG' => 'Singapore',
								'TH' => 'Thailand',
								'TL' => 'Timor-Leste',
								'VN' => 'Vietnam',
							),
						),
						'AS5' => array(
							'name'      => esc_html__( 'Western Asia', 'wpdef' ),
							'countries' => array(
								'AM' => 'Armenia',
								'AZ' => 'Azerbaijan',
								'BH' => 'Bahrain',
								'CY' => 'Cyprus',
								'GE' => 'Georgia',
								'IR' => 'Iran, Islamic Republic of',
								'IQ' => 'Iraq',
								'IL' => 'Israel',
								'JO' => 'Jordan',
								'KW' => 'Kuwait',
								'LB' => 'Lebanon',
								'OM' => 'Oman',
								'QA' => 'Qatar',
								'SA' => 'Saudi Arabia',
								'PS' => 'Palestinian Territory',
								'SY' => 'Syrian Arab Republic',
								'TR' => 'Turkey',
								'AE' => 'United Arab Emirates',
								'YE' => 'Yemen',
							),
						),
					),
				),
				'EU' => array(
					'name' => esc_html__( 'Europe', 'wpdef' ),
					'area' => array(
						'EU1' => array(
							'name'      => esc_html__( 'Eastern Europe', 'wpdef' ),
							'countries' => array(
								'BY' => 'Belarus',
								'BG' => 'Bulgaria',
								'CZ' => 'Czech Republic',
								'HU' => 'Hungary',
								'PL' => 'Poland',
								'MD' => 'Moldova, Republic of',
								'RO' => 'Romania',
								'RU' => 'Russian Federation',
								'SK' => 'Slovakia',
								'UA' => 'Ukraine',
							),
						),
						'EU2' => array(
							'name'      => esc_html__( 'Northern Europe', 'wpdef' ),
							'countries' => array(
								'AX' => 'Aland Islands',
								'DK' => 'Denmark',
								'EE' => 'Estonia',
								'FO' => 'Faroe Islands',
								'FI' => 'Finland',
								'IS' => 'Iceland',
								'IE' => 'Ireland',
								'IM' => 'Isle of Man',
								'LV' => 'Latvia',
								'LT' => 'Lithuania',
								'NO' => 'Norway',
								'SJ' => 'Svalbard and Jan Mayen',
								'SE' => 'Sweden',
								'GB' => 'United Kingdom',
								'GG' => 'Guernsey',
								'JE' => 'Jersey',
							),
						),
						'EU3' => array(
							'name'      => esc_html__( 'Southern Europe', 'wpdef' ),
							'countries' => array(
								'AL' => 'Albania',
								'AD' => 'Andorra',
								'BA' => 'Bosnia and Herzegovina',
								'HR' => 'Croatia',
								'GI' => 'Gibraltar',
								'GR' => 'Greece',
								'VA' => 'Holy See (Vatican City State)',
								'IT' => 'Italy',
								'MT' => 'Malta',
								'ME' => 'Montenegro',
								'MK' => 'North Macedonia',
								'PT' => 'Portugal',
								'SM' => 'San Marino',
								'RS' => 'Serbia',
								'SI' => 'Slovenia',
								'ES' => 'Spain',
							),
						),
						'EU4' => array(
							'name'      => esc_html__( 'Western Europe', 'wpdef' ),
							'countries' => array(
								'AT' => 'Austria',
								'BE' => 'Belgium',
								'FR' => 'France',
								'DE' => 'Germany',
								'LI' => 'Liechtenstein',
								'LU' => 'Luxembourg',
								'MC' => 'Monaco',
								'NL' => 'Netherlands',
								'CH' => 'Switzerland',
							),
						),
					),
				),
				'AM' => array(
					'name' => esc_html__( 'America', 'wpdef' ),
					'area' => array(
						'AM1' => array(
							'name'      => esc_html__( 'Central America', 'wpdef' ),
							'countries' => array(
								'BZ' => 'Belize',
								'CR' => 'Costa Rica',
								'SV' => 'El Salvador',
								'GT' => 'Guatemala',
								'HN' => 'Honduras',
								'MX' => 'Mexico',
								'NI' => 'Nicaragua',
								'PA' => 'Panama',
							),
						),
						'AM2' => array(
							'name'      => esc_html__( 'Caribbean', 'wpdef' ),
							'countries' => array(
								'AI' => 'Anguilla',
								'AG' => 'Antigua and Barbuda',
								'AW' => 'Aruba',
								'BS' => 'Bahamas',
								'BB' => 'Barbados',
								'BQ' => 'Bonaire, Saint Eustatius and Saba',
								'VG' => 'Virgin Islands, British',
								'KY' => 'Cayman Islands',
								'CU' => 'Cuba',
								'CW' => 'Curacao',
								'DM' => 'Dominica',
								'DO' => 'Dominican Republic',
								'GD' => 'Grenada',
								'GP' => 'Guadeloupe',
								'HT' => 'Haiti',
								'JM' => 'Jamaica',
								'MQ' => 'Martinique',
								'MS' => 'Montserrat',
								'PR' => 'Puerto Rico',
								'BL' => 'Saint Barthelemy',
								'KN' => 'Saint Kitts and Nevis',
								'LC' => 'Saint Lucia',
								'MF' => 'Saint Martin',
								'VC' => 'Saint Vincent and the Grenadines',
								'SX' => 'Sint Maarten',
								'TT' => 'Trinidad and Tobago',
								'TC' => 'Turks and Caicos Islands',
								'VI' => 'Virgin Islands, U.S.',
							),
						),
						'AM3' => array(
							'name'      => esc_html__( 'North America', 'wpdef' ),
							'countries' => array(
								'BM' => 'Bermuda',
								'CA' => 'Canada',
								'GL' => 'Greenland',
								'PM' => 'Saint Pierre and Miquelon',
								'US' => 'United States',
								'UM' => 'United States Minor Outlying Islands',
							),
						),
						'AM4' => array(
							'name'      => esc_html__( 'South America', 'wpdef' ),
							'countries' => array(
								'AR' => 'Argentina',
								'BO' => 'Bolivia',
								'BV' => 'Bouvet Island',
								'BR' => 'Brazil',
								'CL' => 'Chile',
								'CO' => 'Colombia',
								'EC' => 'Ecuador',
								'FK' => 'Falkland Islands (Malvinas)',
								'GF' => 'French Guiana',
								'GY' => 'Guyana',
								'PY' => 'Paraguay',
								'PE' => 'Peru',
								'GS' => 'South Georgia and the South Sandwich Islands',
								'SR' => 'Suriname',
								'UY' => 'Uruguay',
								'VE' => 'Venezuela',
							),
						),
					),
				),
				'OC' => array(
					'name' => esc_html__( 'Oceania', 'wpdef' ),
					'area' => array(
						'OC1' => array(
							'name'      => esc_html__( 'Australia and New Zealand', 'wpdef' ),
							'countries' => array(
								'AU' => 'Australia',
								'NZ' => 'New Zealand',
								'CC' => 'Cocos (Keeling) Islands',
								'CX' => 'Christmas Island',
								'HM' => 'Heard Island and McDonald Islands',
							),
						),
						'OC2' => array(
							'name'      => esc_html__( 'Melanesia', 'wpdef' ),
							'countries' => array(
								'FJ' => 'Fiji',
								'NC' => 'New Caledonia',
								'PG' => 'Papua New Guinea',
								'SB' => 'Solomon Islands',
								'VU' => 'Vanuatu',
							),
						),
						'OC3' => array(
							'name'      => esc_html__( 'Micronesia', 'wpdef' ),
							'countries' => array(
								'FM' => 'Micronesia, Federated States of',
								'MH' => 'Marshall Islands',
								'MP' => 'Northern Mariana Islands',
								'GU' => 'Guam',
								'KI' => 'Kiribati',
								'NR' => 'Nauru',
								'PW' => 'Palau',
							),
						),
						'OC4' => array(
							'name'      => esc_html__( 'Polynesia', 'wpdef' ),
							'countries' => array(
								'AS' => 'American Samoa',
								'CK' => 'Cook Islands',
								'PF' => 'French Polynesia',
								'NU' => 'Niue',
								'NF' => 'Norfolk Island',
								'PN' => 'Pitcairn',
								'WS' => 'Samoa',
								'TK' => 'Tokelau',
								'TO' => 'Tonga',
								'TV' => 'Tuvalu',
								'WF' => 'Wallis and Futuna',
							),
						),
					),
				),
			)
		);
	}
}