/**
 * map-script.js
 *
 * Adds a modal with google map with locations and findout the 
 * Geocode to allow customers to choose the address for faster checkouts.
 */
// Code goes here
    jQuery(document).ready(function() {
      var map = null;
      var myMarker;
      var myLatlng;
      var geocoder;

      function addYourLocationButton(map, marker) {
          var controlDiv = document.createElement('div');
          var firstChild = document.createElement('button');
          firstChild.style.backgroundColor = '#fff';
          firstChild.style.border = 'none';
          firstChild.style.outline = 'none';
          firstChild.style.width = '40px';
          firstChild.style.height = '40px';
          firstChild.style.borderRadius = '50px';
          firstChild.style.boxShadow = '0 1px 4px rgba(0,0,0,0.3)';
          firstChild.style.cursor = 'pointer';
          firstChild.style.marginRight = '10px';
          firstChild.style.padding = '0px';
          //firstChild.title = 'My Location';
          controlDiv.appendChild(firstChild);

          var secondChild = document.createElement('div');
          secondChild.style.margin = '11px';
          secondChild.style.width = '20px';
          secondChild.style.height = '20px';
          secondChild.style.backgroundImage = 'url(https://maps.gstatic.com/tactile/mylocation/mylocation-sprite-1x.png)';
          secondChild.style.backgroundSize = '180px 18px';
          secondChild.style.backgroundPosition = '0px 0px';
          secondChild.style.backgroundRepeat = 'no-repeat';
          secondChild.id = 'you_location_img';
          firstChild.appendChild(secondChild);

          google.maps.event.addListener(map, 'dragend', function() {
              jQuery('#you_location_img').css('background-position', '0px 0px');
          });

          firstChild.addEventListener('click', function() {
              var imgX = '0';
              var animationInterval = setInterval(function(){
                  if(imgX == '-18') imgX = '0';
                  else imgX = '-18';
                  jQuery('#you_location_img').css('background-position', imgX+'px 0px');
              }, 500);
              if(navigator.geolocation) {
                  navigator.geolocation.getCurrentPosition(function(position) {
                      showLocation(position);
                      var latlng = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
                      marker.setPosition(latlng);
                      map.setCenter(latlng);
                      clearInterval(animationInterval);
                      jQuery('#you_location_img').css('background-position', '-144px 0px');
                  });
              }
              else{
                  clearInterval(animationInterval);
                  jQuery('#you_location_img').css('background-position', '0px 0px');
              }
          });

          controlDiv.index = 1;
          map.controls[google.maps.ControlPosition.RIGHT_BOTTOM].push(controlDiv);
      }

      function initializeGMap(lat, lng) {
        myLatlng = new google.maps.LatLng(lat, lng);

        var myOptions = {
          zoom: 13,
          zoomControl: false,
          draggable: true,
          center: myLatlng,
          streetViewControl: false,
          mapTypeControl: false,
          fullscreenControl: false,
          mapTypeId: google.maps.MapTypeId.ROADMAP
        };

        geocoder = new google.maps.Geocoder();

        map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
       
        myMarker = new google.maps.Marker({
          position: myLatlng
        });
        myMarker.setMap(map);

        addYourLocationButton(map, myMarker);

        google.maps.event.addListener(map , 'drag', function (event) {
            myMarker.setPosition( map.getCenter());
        });

        google.maps.event.addListener(map , 'dragend', function (event) {
            var position = myMarker.getPosition();
            placeMarker(position);
        });

        google.maps.event.addListener(map, 'click', function(event) {
            myMarker.setPosition( map.getCenter());
            placeMarker(event.latLng);
        });

        google.maps.event.addListener(map, 'dblclick', function(event) {
            var position = myMarker.getPosition();
            placeMarker(position);
        });

        var marker;
        function placeMarker(location) {
            document.getElementById('lat').value=location.lat();
            document.getElementById('lng').value=location.lng();
            showLocation(location);
        }

        /* ------------------- search box code -----------------*/
        var pacContainerInitialized = false; 
        jQuery('#pac-input').keypress(function() { 
          if (!pacContainerInitialized) { 
              jQuery('.pac-container').css('z-index', '9999'); 
              pacContainerInitialized = true; 
          } 
        })

        // Create the search box and link it to the UI element.
        var input = document.getElementById('pac-input');
        
        var pacContainerInitialized = false; 
        jQuery('input').keypress(function() { 
            if (!pacContainerInitialized) { 
                jQuery('.pac-container').css('z-index', '9999'); 
                pacContainerInitialized = true; 
            } 
        })
        var searchBox = new google.maps.places.SearchBox(input);
        map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

        // Bias the SearchBox results towards current map's viewport.
        map.addListener('bounds_changed', function() {
          searchBox.setBounds(map.getBounds());
        });

        var markers = [];
        // Listen for the event fired when the user selects a prediction and retrieve
        // more details for that place.
        searchBox.addListener('places_changed', function() {
          var places = searchBox.getPlaces();

          if (places.length == 0) {
            return;
          }

          // Clear out the old markers.
          markers.forEach(function(marker) {
            marker.setMap(null);
          });
          markers = [];

          // For each place, get the icon, name and location.
          var bounds = new google.maps.LatLngBounds();
          places.forEach(function(place) {
            if (!place.geometry) {
              console.log("Returned place contains no geometry");
              return;
            }
            var icon = {
              url: place.icon,
              size: new google.maps.Size(71, 71),
              origin: new google.maps.Point(0, 0),
              anchor: new google.maps.Point(17, 34),
              scaledSize: new google.maps.Size(25, 25)
            };

            placeMarker(place.geometry.location);
            // Create a marker for each place.
            markers.push(new google.maps.Marker({
              map: map,
              title: place.name,
              position: place.geometry.location
            }));

            if (place.geometry.viewport) {
              // Only geocodes have viewport.
              bounds.union(place.geometry.viewport);
            } else {
              bounds.extend(place.geometry.location);
            }
          });
          map.fitBounds(bounds);

        });

        /*---------------------search box completed ---------------*/
      }

    // Set up global variable
    var result;

    function showPosition() {
        // Store the element where the page displays the result
        result = document.getElementById("result");
        
        jQuery('#myModal').hide();
        // If geolocation is available, try to get the visitor's position
        if(navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(successCallback, errorCallback, {timeout: 30000, enableHighAccuracy: true, maximumAge: 75000});
        } else {
            alert("Sorry, your browser does not support HTML5 geolocation.");
        }
    };

    function showLocation(position) {

        if ( typeof position.coords !== 'undefined' ) {
          //var latitude = position.coords.latitude;
          var latitude = '21.389630';
        } else {
          var latitude = position.lat();
        }

        if ( typeof position.coords !== 'undefined' ) {
          //var longitude = position.coords.longitude;
          var longitude = '39.796610';
        } else {
          var longitude = position.lng();
        }

        jQuery.ajax({
            type:'POST',
            url:"https://awalqatfa.sa/wp-content/plugins/wp-postcode/includes/metabox-p1.php",
            data:'latitude='+latitude+'&longitude='+longitude,
            success:function(data){
                var result = JSON.parse(data);
                //alert(data);
                if(data){
                   jQuery("#location").html(result.location);
                   jQuery("#b_address_1").val(result.billing_address_1);
                   jQuery("#b_address_2").val(result.billing_address_2);
                   jQuery("#b_city").val(result.billing_city);
                   jQuery("#b_state").val(result.billing_state);
                   jQuery("#b_country").val(result.billing_country);
                   jQuery("#b_postcode").val(result.billing_postcode);
                   
                   if(result.message == 'false') {
                        jQuery("#postcode-message").html('Sorry, The address is not eligible for delivery');
                        jQuery("#address-submit").prop('disabled', true);
                        jQuery("#postcode-message").css("color", "red");
                   } else {
                   		jQuery("#postcode-message").html('Items will be delivered to below');
                   		jQuery("#address-submit").prop('disabled', false);
                   		jQuery("#postcode-message").css("color", "green");
                   }
                   
                }else{
                    jQuery("#location").html('Location Not Available');
                }
            }
        });

    }

    // Define callback function for successful attempt
    function successCallback(position) {

        showLocation(position);

        if ( typeof position.coords !== 'undefined' ) {
          var latitude = position.coords.latitude;
        } else {
          var latitude = '39.822910';
        }

        if ( typeof position.coords !== 'undefined' ) {
          var longitude = position.coords.longitude;
        } else {
          var longitude = '39.822910';
        }

        jQuery("#myModal").modal('show');
        initializeGMap(latitude, longitude);
        jQuery("#location-map").css("width", "100%");
        jQuery("#map_canvas").css("width", "100%");
    }
    
    function showConstantLocation(latitude, longitude) {
          jQuery.ajax({
            type:'POST',
            url:"https://awalqatfa.sa/wp-content/plugins/wp-postcode/includes/metabox-p1.php",
            data:'latitude='+latitude+'&longitude='+longitude,
            success:function(data){
                var result = JSON.parse(data);
                //alert(data);
                if(data){
                   jQuery("#location").html(result.location);
                   jQuery("#b_address_1").val(result.billing_address_1);
                   jQuery("#b_address_2").val(result.billing_address_2);
                   jQuery("#b_city").val(result.billing_city);
                   jQuery("#b_state").val(result.billing_state);
                   jQuery("#b_country").val(result.billing_country);
                   jQuery("#b_postcode").val(result.billing_postcode);
                   
                   if(result.message == 'false') {
                        jQuery("#postcode-message").html('Sorry, The address is not eligible for delivery');
                        jQuery("#address-submit").prop('disabled', true);
                        jQuery("#postcode-message").css("color", "red");
                   } else {
                      jQuery("#postcode-message").html('Items will be delivered to below');
                      jQuery("#address-submit").prop('disabled', false);
                      jQuery("#postcode-message").css("color", "green");
                   }
                   
                }else{
                    jQuery("#location").html('Location Not Available');
                }
            }
        });
     }

    // Define callback function for failed attempt
    function errorCallback(error) {
        if(error.code == 1) {
          var latitude = '21.389630';
          var longitude = '39.796610';

          showConstantLocation(latitude, longitude);

          jQuery("#myModal").modal('show');
          initializeGMap(latitude, longitude);
          jQuery("#location-map").css("width", "100%");
          jQuery("#map_canvas").css("width", "100%");

        } else if(error.code == 2) {
          var latitude = '21.389630';
          var longitude = '39.796610';

          showConstantLocation(latitude, longitude);

          jQuery("#myModal").modal('show');
          initializeGMap(latitude, longitude);
          jQuery("#location-map").css("width", "100%");
          jQuery("#map_canvas").css("width", "100%");
        } else if(error.code == 3) {
          var latitude = '21.389630';
          var longitude = '39.796610';

          showConstantLocation(latitude, longitude);

          jQuery("#myModal").modal('show');
          initializeGMap(latitude, longitude);
          jQuery("#location-map").css("width", "100%");
          jQuery("#map_canvas").css("width", "100%");
        } else {
          var latitude = '21.389630';
          var longitude = '39.796610';

          showConstantLocation(latitude, longitude);

          jQuery("#myModal").modal('show');
          initializeGMap(latitude, longitude);
          jQuery("#location-map").css("width", "100%");
          jQuery("#map_canvas").css("width", "100%");
        }
    }

      // Re-init map before show modal
      jQuery("#checkout-init").click(function(){
        showPosition();
      });

      // Re-update map before show modal
      jQuery(document).on('click', '#checkout-update', function(){
        showPosition();
      });

      jQuery("#myModal .close").click(function(){
        jQuery('#location-map').append('<input id="pac-input" class="controls" type="text" placeholder="Search for area, street, landmark"/>');
      });
      
      jQuery( "input[name='billing_country']" ).attr('readonly', true);
      jQuery( "input[name='billing_address_1']" ).attr('readonly', true);
      jQuery( "input[name='billing_address_2']" ).attr('readonly', true);
      jQuery( "input[name='billing_city']" ).attr('readonly', true);
      jQuery( "input[name='billing_field_208']" ).attr('readonly', true);
      jQuery( "input[name='billing_postcode']" ).attr('readonly', true);
      jQuery( "input[name='billing_field_471']" ).attr('readonly', true);

      jQuery("#address-submit").click(function(event) { 
      		
      		jQuery( "input[name='billing_country']" ).attr('readonly', false);
      		var b_address_1 = jQuery( "input[name='b_address_1']" ).val();
      		var b_address_2 = jQuery( "input[name='b_address_2']" ).val();
      		var b_city = jQuery( "input[name='b_city']" ).val();
      		var b_state = jQuery( "input[name='b_state']" ).val();
      		var b_postcode = jQuery( "input[name='b_postcode']" ).val();
      		var b_country = jQuery( "input[name='b_country']" ).val();
            var b_order_note = jQuery("#b_additional_note").val();

      		jQuery( "input[name='billing_country']" ).val(b_country);
      		jQuery( "input[name='billing_address_1']" ).val(b_address_1);
      		jQuery( "input[name='billing_address_2']" ).val(b_address_2);
      		jQuery( "input[name='billing_city']" ).val(b_city);
      		jQuery( "input[name='billing_field_208']" ).val(b_state);
      		jQuery( "input[name='billing_postcode']" ).val(b_postcode).trigger("update_checkout");
            jQuery( "#order_comments" ).val(b_order_note);
       		jQuery("#myModal").modal('hide');
       		jQuery('#location-map').append('<input id="pac-input" class="controls" type="text" placeholder="Search for area, street, landmark"/>');
      });

      jQuery(document).on('click', '#shipping-submit', function(event){
      //jQuery("#shipping-submit").click(function(event) { 
          var b_city = jQuery( "input[name='b_city']" ).val();
          var b_state = jQuery( "input[name='b_state']" ).val();
          var b_postcode = jQuery( "input[name='b_postcode']" ).val();
          /*------------------ calculate shipping fields ---------------*/
          jQuery( "input[name='calc_shipping_state']" ).val(b_state);
          jQuery( "input[name='calc_shipping_city']" ).val(b_city);
          jQuery( "input[name='calc_shipping_postcode']" ).val(b_postcode);
          //jQuery( '.shipping-calculator-form' ).slideDown( 'slow' );
          jQuery("form.woocommerce-shipping-calculator").submit();
          /*------------------ calculate shipping ends ------------------*/
          event.preventDefault();
          jQuery("#myModal").modal('hide');
          jQuery("#checkout-init").hide();
          jQuery("#checkout-update").show();
          jQuery('#location-map').append('<input id="pac-input" class="controls" type="text" placeholder="Search for area, street, landmark"/>');
      });

    });